7                     Ai  G      @i                          F    F    F    F    F   F) f  F    F    F    F 
  F 
  F    F X  F x  F    Gs    G   G *  G    F                                                                        Use HELM To Create An Animated Five-Day Weather Forecast

	In an earlier issue of this magazine (AC 9._), I explained how to create an animated five-day weather forecast using DeluxePaint IV. As I pointed out in that article, some of the tasks are quite tedious, especially the placing of the high and low temperature text for each day. In this article, I show you how to make these tasks easier by using HELM. The book I created is entitled 5DayForecast. It consists of two pages. Page one is the animated forecast screen (Figure 1). Page two is used for entering information about the forecast screen (Figure 2). Let's take a look at page one first.

The Five-Day Forecast Screen
	This screen is a low-resolution interlaced screen with maximum overscan. This can be set in the Display requester which can be accessed via the Author/Display menu item. You may recall that this resolution is what was used in DeluxePaint to create the five-day forecast template. In fact, page one of the HELM book uses that very template. To add the template image to the page, create a linked imagefield that covers the entire page. A linked imagefield is created by clicking on the imagefield tool, in the Draw Tools window, with the right mouse button and selecting Link from the pop-up menu. After drawing a rectangle covering the entire page, a requester will prompt you for the name of a graphic file to link to the imagefield. Once the link is made, the image will always load into the imagefield whenever the page is displayed.
	There are several other objects on the page in addition to the full-page imagefield. There are five textfield objects located in the light blue bar under the title, each centered above the five rectangles containing the AnimBrushes. These hold the names of the days. The background color of these textfields is set to the same light blue as the bar, and the border option is set to none. Therefore, if no text is in these fields, you cannot even tell they exist. The text justification for these textfields is set to Centered so the day names will be centered above the AnimBrushes. The font used for these textfields is CGTimes 30.
	The ten boxes at the bottom of the template are also covered with "invisible" textfield objects. The color, border, and justification for each is set similarly to the day name fields described above. The font used in these textfields is CGTriumviate Bold 30. You may find it useful to create just one textfield first, change its properties, and then use the Object/Duplicate feature of HELM (Figure 3).
	Centered in the five rectangles in the middle of the template are five non-linked imagefields of size 50x183, which you may recall was the size of the AnimBrushes created in DeluxePaint. The speed of each imagefield is set to 20 frames per second. This is done by selecting the Image/Info menu item and setting the Time per Frame to 3. Each time period is one- sixtieth of a second. Also, for the AnimBrushes to actually animate, the Animating Frames and Lock Image options need to be turned on. Again, create one imagefield, set its properties, and then duplicate it. Be aware that DeluxePaint IV does not save a frame rate with AnimBrushes. HELM, however, does. Since there is no way in the version of HELM I am currently using (v1.56) to set the frame rate of an AnimBrush from a script, the frame rate must be set manually each time an AnimBrush is loaded. This is cumbersome. I ended up loading the AnimBrushes into an imagefield, changing their frame rates, and then saving them. The newly saved AnimBrushes will load and run at the appropriate frame rate. There was one interesting side effect to this process: the AnimBrush files were smaller than the original ones saved from DeluxePaint by about 1-2 KB.
	At this point, 5DayForecast is a rather functional program. The day names can be typed into the five textfields, as can the high and low temperatures. The font will already be set and the text will be automatically centered. Finally, the appropriate AnimBrushes can be loaded into the imagefields by selecting each field in turn, choosing the Image/Load menu item, and selecting the AnimBrush to load. The Image menu will be ghosted if the imagefield is locked. Therefore, before selecting an imagefield, choose the Edit/Unlock All menu item. This will unlock all locked objects on the page. After loading the five AnimBrushes, choose the Edit/Unlock All menu item once again to re-lock the objects. Now the Browse Tool button in the Draw Tools window can be pressed to start the animation.
	Even though this five-day animated forecast is easier to use than the one using DeluxePaint, there are still a few things that can be made easier. This is where the information screen on page two of the HELM book comes in. Let's take a closer look at it.

The Five-Day Forecast Information Screen
	This page (Figure 2) has objects allowing you to enter all the information needed by the template screen (Figure 1). There is a radio buttons selector with a list of items (Figure 4) in the upper left corner of the page allowing you to easily select which of the seven sets of five consecutive days you are forecasting. There is a file selector in the upper right corner for selecting AnimBrush files. There are 15 textfields at the bottom of the screen for entering the five high temperatures, the five low temperatures, and the five AnimBrushes to use for the forecast.
	The five objects to the right of the AnimBrush textfields are grouped, mutual exclusive, toggle select push buttons. When one button is pressed, it will be highlighted while the one that is currently selected will have its highlighting removed. When a file is selected from the file selector, its name will be inserted into the AnimBrush textfield to the left of the currently highlighted "<-Select" button. These toggled, mutually exclusive buttons are actually five individual buttons that have been grouped by selecting all of them simultaneously and then selecting the Object/Group menu item. The Exclude Group and Toggle Select items in the Highlight Button Information requester are checked for each button (Figure 5).
	The remaining objects on the page are locked textfields. They include the title at the top of the page, the "Day 1" through "Day 5" labels to the left of the high temperature textfields, and the "High", "Low", and "AnimBrush" labels above the lower group of textfields. It is important that these textfields be locked because after entering text in a textfield, HELM automatically places the cursor in the next available textfield. Since these labels do not need to be edited, the cursor should never jump to them. HELM bypasses locked textfields when repositioning the cursor. The labels above the radio buttons selector and the file selector are the names of the selectors. An object name can be displayed by turning on the Caption option for the object (Figure 6).
	With the interface built, it is time to add functionality to the book. The tasks to be accomplished by this book are too complicated for Actions to perform. Therefore, Scripts are needed. These will be discussed next.

The PageOpen Script for Page Two
	Most of the program action occurs on page two, which is the forecast information screen. When this page first opens, its PageOpen script executes (Listing 1). This script can be edited by going to page two and selecting the Author/Page menu item. Select the Script button when the requester appears. The PageOpen script does only one thing: it issues a Click On command. This command simulates the user clicking on an object on the page. In this case, button id 36 is clicked. This is the top "<-Select" button to the right of the day one AnimBrush filename textfield. This action initializes the group of toggled, mutually exclusive buttons. I used the ID of the button rather than its name because the name for all five of these buttons is the same: "<-Select". They had to be named the same because the name is what appears on the button, and the text on all five buttons needed to be the same.

The SelectDown Script for the <-Select Buttons
	The SelectDown script for button id 36 is shown in Listing 2. It assigns a string value of Day1AnimBrush to the global container DayField. Day1AnimBrush is the name of the textfield containing the AnimBrush name for day one of the forecast. There are similar scripts for each of the other "<-Select" buttons, assigning DayField a value of Day2AnimBrush, Day3AnimBrush, and so on. Be sure to use a SelectDown script for these buttons rather than a SelectUp because the toggling occurs on a SelectDown. If a SelectUp script is used, it is possible for the user to click on one of the buttons and move off of it before releasing the mouse button. In this case, the highlighted button will be mismatched with the AnimBrush textfield name in DayField.

The SelectUp Script for the File Selector
	The SelectUp script for the file selector, named "Select an AnimBrush", is shown in Listing 3. It simply extracts the filename portion of the path and filename combination returned by the file selector and puts it in the textfield referenced by the global container DayField. Notice that the file selector is referenced by the name "me". This name can be used by any script to refer to the object to which the script is attached.

The PageClose Script for Page Two
	Once all the information has been entered on page two, the Go/Next Page menu item can be selected to go to the forecast screen. At this point, the PageClose script for page two will execute (Listing 1). This script is the heart of the book. It extracts the path from the file selector and puts it in a global container named BrushDir. It then extracts the names of the five AnimBrushes to be used by the forecast screen and puts them into five appropriately named global containers. The six global string containers assigned here are used by the PageOpen script of page one.
	Next, a string array named NameOfDays is created containing the seven three-letter abbreviations for the days of the week. This will be used in the upcoming loop.
	Before the loop, the CurDay container is initialized with the value of the radio buttons selector, named "The Five Days", plus one. The radio button selector, having seven items, returns a value ranging from 0 to 6, depending on the currently selected item. This number will determine which day is the first in the forecast. However, since the day abbreviation items in the NameOfDays array are numbered 1 through 7, a one must be added to the value returned by the radio buttons selector.
	Now a loop executes, with the value of i starting at 1 and ending at 5. The string containers FirstName and SecondName are filled with the names of the appropriate high and low temperature textfields, the first of which are named Day1High and Day1Low. String concatenation is used to build these names. The number in container i (e.g. 1) is automatically converted to a string (e.g. "1") when performing the concatenation. Next, the strings in the textfields represented by the FirstName and SecondName containers are inserted into textfields by the same name on page one. These latter textfields reside on the colored rectangles at the bottom of the forecast screen.
	Next, the appropriate three-letter day name abbreviation is extracted from NameOfDays and put into the appropriate textfield on page one. The textfields DayName1 through DayName5 are centered above the five rectangles containing the AnimBrushes on the forecast screen. Make sure the parentheses are around the expression "DayName"&i because the textfield operator has precedence over the & operator. Without the parentheses, HELM will try to concatenate i to the value of the textfield DayName. Since this textfield does not exist, an error will occur during execution.
	Finally, the value of CurDay is updated for the next pass through the loop. The modulo operator (%) causes the value of the expression CurDay%7+1 to increase to seven and then loop back to one. This will prevent an attempt to access an item in NameOfDays that does not exist.

The PageOpen Script for Page One
	The PageOpen script for page one executes when the page is activated. It is shown in Listing 4. It simply combines the directory name stored earlier in the global container BrushDir with each of the five AnimBrush names and then loads the AnimBrushes into the appropriate imagefields. The display is locked before doing this so that the AnimBrushes do not begin animating until they are all loaded. The display is unlocked before the script ends. If the display is not locked first, the imagefields will begin animating and then, one by one, they will be replaced with the new AnimBrushes.

Complaint Department
	The 5DayForecast book works very nicely, but I did get a few headaches putting it together. I am currently using version 1.56 of HELM. Some of the problems I encountered are supposed to be remedied in version 1.61, the latest as of this writing. This version is in the mail, but I did not receive it in time for testing before submitting this article.
	One problem I encountered was innocuous but annoying. After modifying the script for page two and then executing the book, the appropriate AnimBrushes would not load into the imagefields on page one. However, the day names and temperatures were inserted properly. When I went back to page two and then immediately back to page one, all worked well. Something is not executing properly the first time page one is activated after a page script change. This is supposed to be corrected in v1.61.
	Occasionally, the file requester returned a long integer rather than a path and filename. This is supposed to be corrected in v1.61.
	At first I tried to load the AnimBrushes into the imagefields on page one from the PageClose script of page two. This does not work. Apparently, imagefields have to loaded after the page containing them becomes active.
	If the combination of resolution, size, and frame rate of AnimBrushes on a page exceed some critical value, all user control of the program ends. HELM apparently gives precedence to the animating of the images. When this situation occurs, all that can be done is to re-boot.
	HELM crashed a few times, but not many. Generally, they occurred when chip memory was low. One crash was particularly interesting. The animated startup screen asking me to insert the Workbench diskette appeared. I have a hard disk and NEVER insert a Workbench disk. A three-finger salute returned things to normal.
	After printing a script from within the script editor, the clock pointer does not go away even when control is returned to the user. To clear it, exit the script and then re-enter it.
	If a locked imagefield is selected, the Image menu is ghosted. After selecting the Edit/Unlock All menu item, the Image menu is still ghosted even though the imagefield is still selected. The imagefield must be selected again after unlocking it for the Image menu to appear normally.

Needful Things
	I sure wish that the name and the label of an object were not one and the same thing. Sometimes the label for different objects need to be the same, but their names different.
	I wish there was a way to set the frame rate of an AnimBrush with a script command. This would allow the rate to be set at run time rather than at design time. I believe version 1.61 has this feature added.
	There needs to be more flexibility in selecting border colors for objects. Currently, a border can only use consecutive colors in the palette.
	One much needed feature is the ability to change the common properties of multiple objects simultaneously. Currently, the best way to give objects common properties is to create one object, set its properties, and then duplicate it. However, this only works for the same type of objects, not different objects. Also, there are many times when the properties of a group of objects are initially set incorrectly and then need to be changed later. This feature is supposed to be in HELM version 2.0, but I do not know when that version will be available.

Good Things
	Even with the problems I have listed, HELM is still a great product. There are so many features in this software, it is hard to believe that it is the work of essentially one programmer. Eagle Tree Software is very good about listening to user complaints and addressing them in future releases.
	Hope to see you in a future issue.
 a Mac or IBM/compatible, the information and tips can be applied to any platform.  Find out if starting your own computer-based business is right for      Ai                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            9  :          	j  
            <                     #  #  #  %  %  %  '  (  *{  -  /S  0h  0i  0  2  2  2  4P  6>  6  7  8  9  :  ;  ;  ;  <  =W  =  @  @  @  AE  AiĿ翵غĺ                                                                           !     !     !     !     !     !     !     !     !     !     !     
!     
!     	!     !  9        
               @i       	      (T  1  ;  @i                '   a               Ai !     Ai "      
       ! "                    3/30313233349394959697    H H    (FG(    H H    (    d       '                     @                         =/  R    @      H 
-:LaserWriter 
     (  (       :   :      :                                                 